'
' Command to insert a string into a document.
'
Public Class InsertStringCommand
    Implements ICommand
    Private myDocument As Document ' The document to insert into
    Private str As String ' The string to insert
    Private position As Integer ' The position to insert at

    '
    ' Constructor
    '
    ' theDocument - The document to insert into
    ' position - The position to insert at
    ' s - The string to insert
    Public Sub New(ByVal theDocument As Document, ByVal position As Integer, ByVal s As String)
        myDocument = theDocument
        Me.position = position
        Me.str = s
        CommandManager.GetInstance().InvokeCommand(Me)
    End Sub

    '
    ' Perform the command encapsulated by this object.
    '
    ' returns true if this call to doCommand was successful and
    ' can be undone by a call to undoCommand.
    Public Function DoIt() As Boolean _
        Implements ICommand.DoIt
        Try
            myDocument.InsertStringCommand(position, str)
        Catch
            Return False
        End Try
        Return True
    End Function 'DoIt

    '
    ' Undo the command encapsulated by this object.
    '
    ' returns - true if undo was successful
    Public Function UndoIt() As Boolean _
        Implements ICommand.UndoIt
        Try
            myDocument.DeleteCommand(position, str.Length)
        Catch
            Return False
        End Try
        Return True
    End Function
End Class 'InsertStringCommand
